IF EXISTS( SELECT * FROM SYS.OBJECTS 
			WHERE NAME ='TRG_EST_NF_SAI_VENDAS_RC_CLI_ESTATIS_PENDENTE'AND TYPE = 'TR')
BEGIN
	DROP TRIGGER [dbo].[TRG_EST_NF_SAI_VENDAS_RC_CLI_ESTATIS_PENDENTE]
END
GO
GO
GO
CREATE TRIGGER [dbo].[TRG_EST_NF_SAI_VENDAS_RC_CLI_ESTATIS_PENDENTE] ON [dbo].[EST_NF_SAI_VENDAS] 
FOR INSERT
AS
BEGIN TRY
	INSERT INTO RC_CLI_ESTATIS_PENDENTE
	SELECT DISTINCT 
		i.CD_EMP,
		EST_NF_SAI.CD_CLI,
		GETDATE()
	FROM
		INSERTED i INNER JOIN EST_NF_SAI ON
		I.CD_EMP = EST_NF_SAI.CD_EMP AND
		I.CD_FILIAL = EST_NF_SAI.CD_FILIAL AND
		I.CD_NF = EST_NF_SAI.CD_NF
		LEFT JOIN RC_CLI_ESTATIS_PENDENTE C ON
		EST_NF_SAI.CD_EMP = C.CD_EMP AND
		EST_NF_SAI.CD_CLI = C.CD_CLI
	WHERE
		C.CD_EMP IS NULL

END TRY
BEGIN CATCH
	DECLARE @mensagemErro	varchar(250);
	DECLARE @severidadeErro int;
	DECLARE @estadoErro		int;

	SELECT	@mensagemErro	=  ERROR_MESSAGE(), 
		@severidadeErro = ERROR_SEVERITY(), 
		@estadoErro		= ERROR_STATE();
	 
	RAISERROR (@mensagemErro , @severidadeErro , @estadoErro ); 
END CATCH



